IF  EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[V_QUITACAO_NCC]'))
DROP VIEW [dbo].[V_QUITACAO_NCC]
GO

CREATE VIEW [dbo].[V_QUITACAO_NCC]
AS
--TP
-- 0 - PARCELAS
-- 1 - FATURAS
select
	PDV_VD_DEV_NCC_LANC.CD_CTR_LANC_NCC AS CD_LOTE_NCC,
	PDV_VD_DEV_NCC_LANC.DT_CAD AS DT_LOTE_NCC,
	PDV_VD_DEV_NCC_LANC.VLR_LANC AS VLR_LOTE_NCC,
	PDV_VD_DEV_NCC.CD_FILIAL  AS CD_FILIAL_NCC,
	PDV_VD_DEV_NCC.DT_CAD AS DT_NCC,
	PDV_VD_DEV_NCC.VLR_NCC,
	PDV_VD_DEV_NCC.CD_CTR_NCC,
	CONVERT(VARCHAR(15),RC_CREDIARIO_PARC.CD_CTR) AS CD_CONTROLE,
	RC_CREDIARIO_PARC.VLR_PARC_CRED AS VLR_DOCUMENTO,
	RC_CREDIARIO_PARC.PARC_CRED AS PARCELA,
	PDV_VD.CD_FILIAL AS CD_FILIAL,	 
	PDV_VD.NR_ECF,
	PDV_VD.CD_CX,
	0 AS VLR_PGTO_JUR,
	RC_CREDIARIO_PARC_CRED.VLR_CRED as VLR_PGTO,
	0 AS TP	
from 
	PDV_VD_DEV_NCC_LANC INNER JOIN PDV_VD_DEV_NCC_LANC_CPL ON 
	PDV_VD_DEV_NCC_LANC.CD_CTR_LANC_NCC=PDV_VD_DEV_NCC_LANC_CPL.CD_CTR_LANC_NCC INNER JOIN PDV_VD_DEV_NCC ON
	PDV_VD_DEV_NCC_LANC_CPL.CD_CTR_NCC=PDV_VD_DEV_NCC.CD_CTR_NCC INNER JOIN PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED ON
	PDV_VD_DEV_NCC_LANC.CD_CTR_LANC_NCC=PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED.CD_CTR_LANC_NCC INNER JOIN RC_CREDIARIO_PARC ON
	PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED.CD_CTR = RC_CREDIARIO_PARC.CD_CTR INNER JOIN RC_CREDIARIO_PARC_PDV_VD  ON 
	RC_CREDIARIO_PARC.CD_CTR=RC_CREDIARIO_PARC_PDV_VD.CD_CTR INNER JOIN PDV_VD ON
	RC_CREDIARIO_PARC_PDV_VD.CD_EMP=PDV_VD.CD_EMP AND
	RC_CREDIARIO_PARC_PDV_VD.CD_FILIAL=PDV_VD.CD_FILIAL AND
	RC_CREDIARIO_PARC_PDV_VD.CD_VD=PDV_VD.CD_VD INNER JOIN RC_CREDIARIO_PARC_CRED ON 
	PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED.CD_CTR=RC_CREDIARIO_PARC_CRED.CD_CTR AND
	PDV_VD_DEV_NCC_LANC_RC_CREDIARIO_PARC_CRED.CD_CTR_CRED =RC_CREDIARIO_PARC_CRED.CD_CTR_CRED 	
UNION ALL
select
	PDV_VD_DEV_NCC_LANC.CD_CTR_LANC_NCC AS CD_LOTE_NCC,
	PDV_VD_DEV_NCC_LANC.DT_CAD AS DT_LOTE_NCC,
	PDV_VD_DEV_NCC_LANC.VLR_LANC AS VLR_LOTE_NCC,
	PDV_VD_DEV_NCC.CD_FILIAL  AS CD_FILIAL_NCC,
	PDV_VD_DEV_NCC.DT_CAD AS DT_NCC,
	PDV_VD_DEV_NCC.VLR_NCC,
	PDV_VD_DEV_NCC.CD_CTR_NCC,
	RC_DEB.NR_FATURA AS CD_CONTROLE,
	RC_DEB.VLR_DP AS VLR_DOCUMENTO,
	0 AS PARCELA,
	RC_DEB.CD_FILIAL AS CD_FILIAL,	 
	0 AS NR_ECF,
	0 AS CD_CX,
	RC_CRED.VL_JUR AS VLR_PGTO_JUR,
	(RC_CRED.VL_PGTO - RC_CRED.VL_JUR) AS VLR_PGTO,
	1 AS TP	
from 
	PDV_VD_DEV_NCC_LANC INNER JOIN PDV_VD_DEV_NCC_LANC_CPL ON 
	PDV_VD_DEV_NCC_LANC.CD_CTR_LANC_NCC=PDV_VD_DEV_NCC_LANC_CPL.CD_CTR_LANC_NCC INNER JOIN PDV_VD_DEV_NCC ON
	PDV_VD_DEV_NCC_LANC_CPL.CD_CTR_NCC=PDV_VD_DEV_NCC.CD_CTR_NCC INNER JOIN PDV_VD_DEV_NCC_LANC_RC_CRED ON 
	PDV_VD_DEV_NCC_LANC.CD_CTR_LANC_NCC=PDV_VD_DEV_NCC_LANC_RC_CRED.CD_CTR_LANC_NCC INNER JOIN RC_DEB ON
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_EMP=RC_DEB.CD_EMP AND
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_FILIAL=RC_DEB.CD_FILIAL AND
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_RC_DEB=RC_DEB.CD_RC_DEB INNER JOIN RC_CRED ON 
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_EMP=RC_CRED.CD_EMP AND
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_FILIAL=RC_CRED.CD_FILIAL AND
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_RC_DEB=RC_CRED.CD_RC_DEB  AND
	PDV_VD_DEV_NCC_LANC_RC_CRED.CD_DP_LANC=RC_CRED.CD_DP_LANC
